#ifndef LIBPDFTOIMAGE_READ_PDF_H
#define LIBPDFTOIMAGE_READ_PDF_H

#include <filesystem>
#include <vector>


class ReadPDF {

public:

    static int getPDFPageCount(const std::filesystem::path& pdfPath);

    static std::vector<std::array<double, 2>> getPageOriginalSizes(
        const std::filesystem::path& pdfPath,
        const std::vector<int>& pageIndexes
    );

    static std::tuple<std::vector<unsigned char>, int> getPDFPageBuffer(
        const std::filesystem::path& pdfPath,
        const int& pageActualIndex,
        const int& renderingWidthPixels,
        const int& renderingHeightPixels
    );

};



#endif //LIBPDFTOIMAGE_READ_PDF_H