#ifndef LIBPDFTOIMAGE_OPTIONS_H
#define LIBPDFTOIMAGE_OPTIONS_H

#include <expected>
#include <filesystem>
#include <vector>


class Options {

public:

    /**
     * std::filesystem::path pdfPath;
     * std::vector<std::filesystem::path> pageImagePaths;
     * std::string imageSize;
     * std::vector<int> pageIndexes;
     * int imageQuality;
     */
    static
    std::expected<
        std::tuple<
            std::filesystem::path,
            std::vector<std::filesystem::path>,
            std::vector<std::array<int, 2>>,
            std::vector<int>,
            int,
            int
        >,
        std::string
    >
    getOptions(const int& argc, const std::vector<std::string>& argVector);

private:

    static std::tuple<bool, std::filesystem::path> getPDFPath(const std::string& str);

    static std::expected<int, std::string> getDigitsFromString(const std::string& str);

    static std::tuple<int, int> getDpiResolution(
        const double& pageOriginalWidthPoints,
        const double& pageOriginalHeightPoints,
        const int& dpi
    );

};

#endif //LIBPDFTOIMAGE_OPTIONS_H