#ifndef LIBPDFTOIMAGE_SAVE_IMAGE_H
#define LIBPDFTOIMAGE_SAVE_IMAGE_H

#include <filesystem>
#include <vector>


class SaveImage {

public:

    /**
     * @brief Save the specific page of the given PDF document as an image with restricted width or height.
     * @param pdfPath the path of the PDF document
     * @param actualPageIndex the index starting from 0, calculated by the inputted index minus 1
     * @param pageImagePath the path of the output image
     * @param renderingWidthPixels the width of the output image
     * @param renderingHeightPixels the height of the output image
     * @param imageQuality the quality of the output image if the format is JPEG
     * @return
     */
    static bool savePDFToImage(
        const std::filesystem::path& pdfPath,
        const int& actualPageIndex,
        const std::filesystem::path& pageImagePath,
        const int& renderingWidthPixels,
        const int& renderingHeightPixels,
        const int& imageQuality
    );

private:

    static std::vector<unsigned char> bufferBGRAToRGB(
        const unsigned char* bufferBGRA,
        const int& renderingWidthPixels,
        const int& renderingHeightPixels,
        const int& stride
    );

    static bool saveBufferToJPEG(
        const std::filesystem::path& pageImagePath,
        const int& renderingWidthPixels,
        const int& renderingHeightPixels,
        const int& imageQuality,
        const int& channels,
        unsigned char* buff
    );

    static bool saveBufferToPNG(
        const std::filesystem::path& pageImagePath,
        const int& renderingWidth,
        const int& renderingHeight,
        const int& channels,
        unsigned char* buff
    );

};

#endif //LIBPDFTOIMAGE_SAVE_IMAGE_H