#include <iostream>
#include <ranges>
#include <filesystem>
#include <algorithm>

#ifdef _WIN32
#include <windows.h>
#endif

#include "options.h"
#include "save.h"
#include "help.h"


int main(int argc, char *argv[]) {
#ifdef _WIN32
    SetConsoleOutputCP(CP_UTF8);
    SetConsoleCP(CP_UTF8);
#endif

    if (argc == 1) {
        showHelp("--help");
        return 0;
    }

    for (int i = 1; i < argc; ++i) {
        std::string arg = argv[i];
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            showHelp(argv[i]);
            return 0;
        }
    }

    /**
     * std::filesystem::path pdfPath;
     * std::vector<std::filesystem::path> pageImagePaths;
     * std::vector<std::array<int, 2>> imageSizes;
     * std::vector<int> pageIndexes;
     * int imageQuality;
    */

    auto optionsResult = getOptions(argc, argv);

    if (optionsResult.has_value()) {
        auto [
        pdfPath, pageImagePaths, imageSizes, pageIndexes, imageQuality
        ] = optionsResult.value();

        std::cout << pdfPath << "\n\n";

        std::vector<bool> saveResults;

        for (int i = 0; i < pageIndexes.size(); ++i) {
            std::filesystem::path pageImagePath = pageImagePaths[i];
            auto [renderingWidthPixels, renderingHeightPixels] = imageSizes[i];

            bool saveResult = savePDFToImage(
                pdfPath,
                pageIndexes[i] - 1, pageImagePath,
                renderingWidthPixels, renderingHeightPixels,
                imageQuality
                );

            if (saveResult) {
                std::cout << pageIndexes[i] << " "
                << pageImagePath << " " << renderingWidthPixels << "x" << renderingHeightPixels
                << "\n\n";
            }

            saveResults.emplace_back(saveResult);
        }

        if (pageIndexes.size() == saveResults.size() && !std::ranges::contains(saveResults, false)) {
            return 0;
        }
    }

    std::cout << optionsResult.error() << "\n\n";

    return 1;
}
