#include "help.h"

void showHelp(std::string_view option) {
    if (option == "-v" || option == "--help") {
        std::cout << "libPDFToImage\n\n"
                     "A library utilizing PDFium to save a page of a PDF document as an image.\n\n";
        std::cout << "Version 1.0.1\n\n";
        std::cout << "The library is released under GNU Lesser General Public License version 3.0,\n"
                     "while the executable program is released under Apache License version 2.0.\n\n";
        std::cout << "The library dynamically uses libjpeg, libpng and PDFium library.\n\n"
                     "Please install the packages of libturbojpeg and libpng if the system you are\n"
                     "using does not install them by default.\n\n";
        std::cout << "You may visit https://github.com/bblanchon/pdfium-binaries and download the\n"
                     "latest release for the system that you are using. For a 64-bit Linux distro,\n"
                     "it is pdfium-linux-x64.tgz. Before using libPDFToImage, please copy the library\n"
                     "libpdfium.so into the folder of libPDFToImage's binary.\n\n";
    }

    if (option == "-h" || option == "--help") {
        std::cout << "How to Use the Executable Program\n\n"
                     "pdfToImage <file> [options]\n\n";
        std::cout << "The path of a file or a directory should be enclosed in double quotation marks\n"
                     "if there is a space in the path.\n\n";
        std::cout << "Options:\n\n";
        std::cout << "-o <directory>  The path of the folder for saving images.\n"
                     "                Without the option, it is the current folder.\n"
                     "                A subdirectory will automatically created in the given folder\n"
                     "                for saving images, and the subdirectory and images are automatically\n"
                     "                named based on the name of the PDF file.\n\n"
                     "-d              Generate images with a given dpi.\n"
                     "                Without the option, images are generated with 96 dpi.\n\n"
                     "-s              Generate images with a given pixel size.\n"
                     "                For example, \"1920\" means width pixels, or \"x1080\" means height \n"
                     "                pixels, and the size will be changed with the aspect ratio of the PDF\n"
                     "                page's original size;\n"
                     "                \"1920x1080\" restricts both of width and height regardless of the\n"
                     "                aspect ratio.\n"
                     "                Without the option, the pixel resolution of images are decided according\n"
                     "                to the original size of images with 96 dpi.\n\n"
                     "-p              The first page is 1.\n"
                     "                Page numbers are written like \"1, 2, 3-5, -8, 10-\" are acceptable.\n"
                     "                Without the option, all pages will be saved to images.\n\n"
                     "-e              jpeg or png.\n"
                     "                \"jpeg\" can be written as \"jpg\".\n"
                     "                The processing of the formats depends on libjpeg and libpng in the system.\n"
                     "                Without the option, the program saves images in the format of PNG.\n\n"
                     "-q              The number from 1 to 100.\n\n";
    }
}
