#include "specific_os.h"


#ifdef _WIN32

std::vector<std::string> SpecificOS::getArgvFromWchar() {
    LPWSTR commandLine = GetCommandLineW();
    int argc;
    LPWSTR* argvWchar = CommandLineToArgvW(commandLine, &argc);

    std::vector<std::string> argvUTF8;

    for (int i = 0; i < argc; ++i) {
        auto utf8String = convertWcharToUTF8(argvWchar[i]);
        argvUTF8.push_back(utf8String);
    }

    LocalFree(argvWchar);

    return argvUTF8;
}

std::string SpecificOS::convertWcharToUTF8(LPWSTR wcharString) {
    std::string utf8String;

    int length = WideCharToMultiByte(CP_UTF8, 0, wcharString, -1, nullptr, 0, nullptr, nullptr);
    if (length > 0) {
        utf8String.resize(length);
        WideCharToMultiByte(CP_UTF8, 0, wcharString, -1, &utf8String[0], length, nullptr, nullptr);

        if (utf8String[utf8String.size() - 1] == '\0') {
            utf8String.erase(utf8String.size() - 1, 1);
        }
    }

    return utf8String;
}

std::wstring SpecificOS::convertUTF8ToWchar(const std::string& utf8String) {
    std::wstring wcharString;

    int length = MultiByteToWideChar(CP_UTF8, 0, utf8String.c_str(), -1, nullptr, 0);
    if (length > 0) {
        wcharString.resize(length);
        MultiByteToWideChar(CP_UTF8, 0, utf8String.c_str(), -1, &wcharString[0], length);
    }

    return wcharString;
}

#endif