#ifndef LIBJSONHANDLE_DATA_HANDLING_H
#define LIBJSONHANDLE_DATA_HANDLING_H

#include <string>
#include <vector>
#include <tuple>


class DataHandling {

public:

    static std::tuple<bool, std::pair<std::string, std::string>, std::string> dataQuery(
        const std::string& jsonData,
        const std::string& queryString,
        const std::string& queryConditions
    );

    static std::tuple<bool, std::pair<std::string, std::string>, std::string> dataEdit(
        const std::string& jsonData,
        const std::string& editString,
        const std::string& editConditions
    );

    static std::string generateJSONFromDict(
        const std::vector<std::pair<std::string, std::pair<std::string, std::string>>>& dict
    );

private:
    static std::vector<std::string> marks;

    static std::string loadJSONText(const std::string& jsonTextRaw);

    static std::vector<std::string> splitJSON(const std::string& text);

    static std::vector<std::string> splitNest(const std::string& text);

    static std::vector<std::pair<std::string, std::pair<std::string, std::string>>>
    generateDict(const std::string& jsonText);

    static std::pair<std::string, std::string> getKeysAndValue(std::string stringRaw);

    static
    std::tuple<
        std::vector<std::pair<std::vector<std::string>, std::string>>,
        std::vector<std::pair<std::vector<std::string>, std::string>>
    >
    recognizeConditions(const std::string& requestConditions, const std::string& queryKeys);

    static std::vector<std::string> updateHierarchy(
        std::vector<std::string> hierarchyVector,
        const std::string& key,
        int braceIndex
    );

    static bool compareVectors(const std::vector<std::string>& vector1, const std::vector<std::string>& vector2);

    static std::pair<std::array<int, 3>, std::pair<std::string, std::string>>
    getArrayFromDict(
        const std::vector<std::pair<std::string, std::pair<std::string, std::string>>>& dict,
        int objectIndexInArray,
        int arrayBeginningIndexInDict
    );

    static std::pair<std::array<int, 3>, std::pair<std::string, std::string>>
    getObjectFromDict(
        const std::vector<std::pair<std::string, std::pair<std::string, std::string>>>& dict,
        int objectIndexInArray,
        int objectBeginningIndexInDict
    );

    static std::tuple<bool, std::pair<std::string, std::string>, std::string>
    handleRequest(
        const std::string& requestType,
        const std::string& jsonData,
        const std::string& queryKeys,
        const std::string& editValue,
        const std::string& requestConditions
    );

};

#endif //LIBJSONHANDLE_DATA_HANDLING_H