#include <iostream>
#include <filesystem>

#ifdef _WIN32
#include <windows.h>
#endif

#include "options.h"
#include "help.h"
#include "data_handling.h"


int main(int argc, char *argv[]) {
#ifdef _WIN32
    SetConsoleOutputCP(CP_UTF8);
    SetConsoleCP(CP_UTF8);
#endif

    if (argc == 1) {
        Help::showHelp("--help");
        return 0;
    }

    for (int i = 1; i < argc; ++i) {
        std::string arg = argv[i];
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            Help::showHelp(argv[i]);
            return 0;
        }
    }

    auto optionsResult = Options::getOptions(argc, argv);

    if (optionsResult.has_value()) {
        auto [jsonText, requestType, requestString, condition] = optionsResult.value();

        if (requestType == "edit") {
            auto [
            requestState,
            valuePair,
            editedJSONData
            ] = DataHandling::dataEdit(jsonText, requestString, condition);

            if (requestState) {
                std::cout << "Here is the edited JSON text:\n"
                          << editedJSONData
                          << std::endl;
            } else {
                std::cout << "Nothing is edited." << std::endl;
            }
        } else {
            auto [
            requestState,
            valuePair,
            editedJSONData
            ] = DataHandling::dataQuery(jsonText, requestString, condition);

            if (requestState) {
                std::cout << "The result of the query " << requestString
                          << " is " << valuePair.second << "."
                          << std::endl;
            } else {
                std::cout << "Nothing is found." << std::endl;
            }
        }

    } else {
        std::cout << optionsResult.error() << std::endl;
    }

    return 0;
}