#include "help.h"


void Help::showHelp(const std::string_view& option) {
    if (option == "-v" || option == "--help") {
        std::cout << "libJSONHandle\n\n"
                     "A library that makes a query or an edit in a JSON text.\n\n";
        std::cout << "Version 1.2.0\n\n";
        std::cout << "The library is released under GNU Lesser General Public License version 3.0,\n"
                     "while the executable program is released under Apache License version 2.0.\n\n";
    }

    if (option == "-h" || option == "--help") {
        std::cout << "How to Use the Executable Program\n\n"
                     "jsonHandle [options]\n\n"
                     "For example:\n"
                     "1. Make a query\n"
                     "jsonHandle example.json "
                     "-q candidates.content.parts.text "
                     "-c candidates.content.role=model\n"
                     "2. Make an edit\n"
                     "jsonHandle example.json "
                     "-e \"hardware.gpu model=NVIDIA GeForce RTX 4060\" "
                     "-c hardware.id=12345\n\n";
        std::cout << "Options:\n\n";
        std::cout << "<file>          The path of a JSON file.\n"
                     "                The file path should be enclosed in double quotation marks\n"
                     "                if it contains a space.\n"
                     "                When the option is lacking, or the path is invalid, the \n"
                     "                program will ask for providing a JSON text.\n\n"
                     "-q              The query.\n"
                     "                The hierarchy keys are separated by a dot. \n"
                     "                If there is a space in the query, the query should be enclosed \n"
                     "                in double quotation marks.\n"
                     "For example:\n"
                     "-q candidates.content.parts.text\n"
                     "-q \"hardware.gpu brand\"\n\n"
                     "-e              The assignment expression for an edit.\n"
                     "                The hierarchy keys are separated by a dot.\n"
                     "                There is an equals sign between the keys and the value.\n"
                     "                If there is any space, the string with a space or the entire\n"
                     "                string should be enclosed in double quotation marks.\n"
                     "For example:\n"
                     "-e \"hardware.cpu model\"=\"Intel Core i9 14900\"\n"
                     "-e \"hardware.gpu model=NVIDIA GeForce RTX 4060\"\n\n"
                     "-c              The conditions for the query.\n"
                     "                The hierarchy keys are separated by a dot.\n"
                     "                There is an equals sign between the keys and the value.\n"
                     "                Multiple conditions are separated by a comma.\n"
                     "                If there is any space, the string with a space or the entire\n"
                     "                string should be enclosed in double quotation marks.\n"
                     "For example:\n"
                     "-c candidates.content.role=model\n"
                     "-c \"device type\"=\"Raspberry Pi\"\n"
                     "-c \"device type=Personal Computer,hardware.cpu brand=AMD\"\n\n";
    }
}