#include "format_handling.h"


std::string FormatHandling::removeTwoSideSpace(std::string string) {
    while (string[0] == ' ') {
        string.erase(0, 1);
    }

    while (string[string.size() - 1] == ' ') {
        string.erase(string.size() - 1, 1);
    }

    return string;
}

/* According to json.org, specific characters should be escaped.
 */
std::string FormatHandling::escapeCharacters(const std::string& text) {
    std::string escapedText;

    for (auto& c : text) {
        if (c == '"') {
            escapedText += '\\';
            escapedText += '"';
        } else if (c == '\\') {
            escapedText += '\\';
            escapedText += '\\';
        } else if (c == '/') {
            escapedText += '\\';
            escapedText += '/';
        } else if (c == '\b') {
            escapedText += '\\';
            escapedText += 'b';
        } else if (c == '\f') {
            escapedText += '\\';
            escapedText += 'f';
        } else if (c == '\n') {
            escapedText += '\\';
            escapedText += 'n';
        } else if (c == '\r') {
            escapedText += '\\';
            escapedText += 'r';
        } else if (c == '\t') {
            escapedText += '\\';
            escapedText += 't';
        } else if (c == '\0') {
            escapedText += '\\';
            escapedText += "u0000";
        } else if (c == '\x01') {
            escapedText += '\\';
            escapedText += "u0001";
        } else if (c == '\x02') {
            escapedText += '\\';
            escapedText += "u0002";
        } else if (c == '\x03') {
            escapedText += '\\';
            escapedText += "u0003";
        } else if (c == '\x04') {
            escapedText += '\\';
            escapedText += "u0004";
        } else if (c == '\x05') {
            escapedText += '\\';
            escapedText += "u0005";
        } else if (c == '\x06') {
            escapedText += '\\';
            escapedText += "u0006";
        } else if (c == '\a') {
            escapedText += '\\';
            escapedText += "u0007";
        } else if (c == '\v') {
            escapedText += '\\';
            escapedText += "u000B";
        } else if (c == '\x0E') {
            escapedText += '\\';
            escapedText += "u000E";
        } else if (c == '\x0F') {
            escapedText += '\\';
            escapedText += "u000F";
        } else if (c == '\x10') {
            escapedText += '\\';
            escapedText += "u0010";
        } else if (c == '\x11') {
            escapedText += '\\';
            escapedText += "u0011";
        } else if (c == '\x12') {
            escapedText += '\\';
            escapedText += "u0012";
        } else if (c == '\x13') {
            escapedText += '\\';
            escapedText += "u0013";
        } else if (c == '\x14') {
            escapedText += '\\';
            escapedText += "u0014";
        } else if (c == '\x15') {
            escapedText += '\\';
            escapedText += "u0015";
        } else if (c == '\x16') {
            escapedText += '\\';
            escapedText += "u0016";
        } else if (c == '\x17') {
            escapedText += '\\';
            escapedText += "u0017";
        } else if (c == '\x18') {
            escapedText += '\\';
            escapedText += "u0018";
        } else if (c == '\x19') {
            escapedText += '\\';
            escapedText += "u0019";
        } else if (c == '\x1A') {
            escapedText += '\\';
            escapedText += "u001A";
        } else if (c == '\x1B') {
            escapedText += '\\';
            escapedText += "u001B";
        } else if (c == '\x1C') {
            escapedText += '\\';
            escapedText += "u001C";
        } else if (c == '\x1D') {
            escapedText += '\\';
            escapedText += "u001D";
        } else if (c == '\x1E') {
            escapedText += '\\';
            escapedText += "u001E";
        } else if (c == '\x1F') {
            escapedText += '\\';
            escapedText += "u001F";
        } else {
            escapedText += c;
        }
    }

    return escapedText;
}

std::string FormatHandling::escapeDoubleQuotationMarks(const std::string& jsonText) {
    std::string escapedJSONText;

    /* The character \ should be escaped by \\ for indicating the character
     * instead of performing as an escape character.
     */
    int i = 0;
    while (i < jsonText.size()) {
        if (jsonText[i] == '"' && jsonText[i - 1] == '\\') {
            std::string mark = "u0022";
            escapedJSONText += mark;
        } else {
            escapedJSONText += jsonText[i];
        }

        ++i;
    }

    return escapedJSONText;
}

std::string FormatHandling::parseCharacters(const std::string& text) {
    std::string parsedText;

    int i = 0;
    while (i < text.size()) {
        if (text[i] == '\\' && i + 5 < text.size() && text.substr(i + 1, 5) == "u0022") {
            parsedText += '"';
            i = i + 6;
        } else if (text[i] == '\\' && i + 5 < text.size() && text.substr(i + 1, 5) == "u003c") {
            parsedText += '<';
            i = i + 6;
        } else if (text[i] == '\\' && i + 5 < text.size() && text.substr(i + 1, 5) == "u003e") {
            parsedText += '>';
            i = i + 6;
        } else if (text[i] == '\\' && i + 1 < text.size() && text[i + 1] == 'n') {
            parsedText += '\n';
            i = i + 2;
        } else {
            parsedText += text[i];
            ++i;
        }
    }

    return parsedText;
}