#ifndef LIBJSONHANDLE_DATAQUERY_H
#define LIBJSONHANDLE_DATAQUERY_H

#include <string>
#include <vector>
#include <tuple>
#include <filesystem>


class DataQuery {

public:

    static std::string removeTwoSideSpace(std::string string);

    static std::string loadJSONFile(const std::filesystem::path& filePath);

    static std::pair<std::string, std::string> dataQuery(
        const std::string& jsonData,
        const std::string& queryString,
        const std::string& queryConditions
    );

private:
    static std::vector<std::string> marks;

    static std::vector<std::string> splitJSON(const std::string& text);

    static std::vector<std::string> splitNest(std::string text);

    static std::string loadJSONText(const std::string& jsonTextRaw);

    static bool compareVectors(const std::vector<std::string>& vector1, const std::vector<std::string>& vector2);

    static std::vector<std::string> updateHierarchy(
        std::vector<std::string> hierarchyVector,
        const std::string& key,
        int braceIndex
    );

    static
    std::tuple<
        std::vector<std::pair<std::vector<std::string>, std::string>>,
        std::vector<std::pair<std::vector<std::string>, std::string>>
    >
    recognizeConditions(const std::string& queryConditions, const std::string& queryString);

    static std::vector<std::pair<std::string, std::pair<std::string, std::string>>>
    generateDict(const std::string& jsonText);

};

#endif //LIBJSONHANDLE_DATAQUERY_H