#ifndef LIBJSONHANDLE_PARSE_H
#define LIBJSONHANDLE_PARSE_H

#include <string>
#include <filesystem>
#include <vector>


class Parse {

public:

    static std::string loadJSONFile(const std::filesystem::path& filePath);

    static std::string dictQuery(const std::string& jsonText, const std::string& string);

private:

    static std::string escapeDoubleQuotationMarks(const std::string& jsonText);

    static std::string parseCharacters(const std::string& text);

    static std::string loadJSONText(const std::string& jsonTextRaw);

    static std::vector<std::pair<std::string, std::string>> generateDict(const std::string& jsonText);

};

#endif //LIBJSONHANDLE_PARSE_H