#include "options.h"

#include <iostream>

#include "parse.h"


std::expected<std::array<std::string, 2>, std::string>
Options::getOptions(int argc, char** argv) {
    // All available options.
    std::vector<std::string> options = {
        "-q"   // The query
    };

    std::string jsonText;
    std::string query;

    // argv[0] is the program's filename.
    int i = 1;
    while (i < argc) {
        std::string arg = argv[i];
        if (arg == "-q" && i + 1 < argc) {
            query = argv[i + 1];
            i = i + 2;
        } else {
            if (std::filesystem::exists(arg)) {
                std::filesystem::path filePath = arg;
                jsonText = Parse::loadJSONFile(filePath);
            }
            ++i;
        }
    }

    if (jsonText.empty()) {
        std::cout << "No valid JSON file is found. \n"
                     "You may paste the text of complete JSON-format data here.\n";

        std::string line;
        while (std::getline(std::cin, line)) {
            jsonText += line;
            if (line.empty()) {
                break;
            }
        }
    }

    if (query.empty()) {
        std::cout << "Please input a query.\n"
                     "The parts of the query hierarchy are separated by a dot. \n"
                     "For example:\n"
                     "If you use [\"output\"][0][\"content\"][0][\"text\"] for a query in Python, \n"
                     "here you input output.0.content.0.text for a query.\n\n"
                     "Your query:\n";
        std::getline(std::cin, query);
    }

    if (jsonText.empty()) {
        return std::unexpected("No JSON text is found.");
    }

    auto cleanString = [](std::string string) {
        if (string[0] == '"') {
            string.erase(0, 1);
        }

        if (string[string.size() - 1] == '"') {
            string.erase(string.size() - 1, 1);
        }

        while (string[0] == ' ') {
            string.erase(0, 1);
        }

        while (string[string.size() - 1] == ' ') {
            string.erase(string.size() - 1, 1);
        }

        return string;
    };

    query = cleanString(query);

    if (query.empty()) {
        return std::unexpected("There is no query.");
    }

    return std::array{jsonText, query};
}