#include <iostream>
#include <filesystem>

#include "options.h"
#include "help.h"
#include "parse.h"


int main(int argc, char *argv[]) {
    if (argc == 1) {
        Help::showHelp("--help");
        return 0;
    }

    for (int i = 1; i < argc; ++i) {
        std::string arg = argv[i];
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            Help::showHelp(argv[i]);
            return 0;
        }
    }

    auto optionsResult = Options::getOptions(argc, argv);

    if (optionsResult.has_value()) {
        auto [jsonText, query] = optionsResult.value();

        auto dictQueryResult = Parse::dictQuery(jsonText, query);

        std::cout << dictQueryResult << std::endl;
    } else {
        std::cout << optionsResult.error() << std::endl;
    }

    return 0;
}