#include "help.h"


void Help::showHelp(const std::string_view& option) {
    if (option == "-v" || option == "--help") {
        std::cout << "libJSONHandle\n\n"
                     "A library that makes a query in a JSON text.\n\n";
        std::cout << "Version 1.0.0\n\n";
        std::cout << "The library is released under GNU Lesser General Public License version 3.0,\n"
                     "while the executable program is released under Apache License version 2.0.\n\n";
    }

    if (option == "-h" || option == "--help") {
        std::cout << "How to Use the Executable Program\n\n"
                     "jsonHandle [options]\n\n"
                     "For example:\n"
                     "jsonHandle example.json -q output.0.content.0.text\n"
                     "jsonHandle inventory.json -q \"products.20.product names.brand name\"\n\n";
        std::cout << "Options:\n\n";
        std::cout << "<file>          The path of a JSON file.\n"
                     "                The file path should be enclosed in double quotation marks\n"
                     "                if it contains a space.\n"
                     "                When the option is lacking, or the path is invalid, the \n"
                     "                program will ask for providing a JSON text.\n\n"
                     "-q              The query.\n"
                     "                The parts of the query hierarchy are separated by a dot. \n"
                     "                If there is a space in the query, the query should be enclosed \n"
                     "                in double quotation marks.\n"
                     "For example:\n"
                     "If you use [\"output\"][0][\"content\"][0][\"text\"] for a query in Python, \n"
                     "here you use \"output.0.content.0.text\" for a query.\n\n";
    }
}