#ifndef LIBIMAGETOPDF_SAVE_PDF_H
#define LIBIMAGETOPDF_SAVE_PDF_H

#include <fstream>
#include <vector>
#include <filesystem>

#include <zlib.h>

#include "handle_image.h"


class SavePDF {

public:

    static bool createPDF(
        const std::vector<std::filesystem::path>& imagePaths,
        const std::filesystem::path& outputPDFPath,
        const std::array<int, 2>& paperSize,
        const int& outputWidth,
        const int& outputQuality,
        const int& imageNumberPerPage,
        const std::array<int, 4>& margins,
        const std::array<int, 2>& spacings
    );

private:

    static std::string encodeJPEG(const HandleImage::ImageData& imageData);
    static std::string encodePNG(const HandleImage::ImageData& imageData);

    static std::array<int, 2> getPaperSizePoints(
        const std::vector<HandleImage::ImageData>& images,
        const std::vector<int>& imageIndexes,
        const std::array<int, 2>& paperSize,
        const int& imageNumberPerPage
    );

    static std::string createContentStream(
        const std::vector<int>& imageIndexes,
        const std::vector<std::array<int, 4>>& imageRects
    );

    static std::string createPage(
        const std::vector<int>& imageObjectIDs,
        const std::vector<int>& contentObjectIDs,
        const int& pagesInfoObjectID,
        const std::vector<int>& imageIndexes,
        const std::array<int, 2>& paperSizePoints,
        const int& pageIndex
    );

    static std::string generatePagesInfo(const std::vector<int>& pageObjectIDs);
    static std::string generateCatalog(const int& pagesInfoObjectID);
    static std::string generateDocumentInfo();

    static std::string generatePDFID();

    static void addObject(
        std::ostringstream& buffer,
        std::vector<size_t>& objectOffsets,
        const int& objectID,
        const std::string& content
    );

    static void writeXrefStreamData(
        std::ostringstream& xrefStreamData,
        size_t value,
        const int& byteWidth
    );

    static void generateXref(
        std::ostringstream& buffer,
        const std::vector<size_t>& objectOffsets,
        const int& xrefObjectID,
        const int& catalogObjectID,
        const int& documentInfoObjectID
    );

};

#endif //LIBIMAGETOPDF_SAVE_PDF_H