#ifndef LIBIMAGETOPDF_OPTIONS_H
#define LIBIMAGETOPDF_OPTIONS_H

#include <expected>
#include <filesystem>
#include <vector>


class Options {

public:

    /* std::vector<std::filesystem::path> imagePaths
     * std::filesystem::path pdfPath
     * std::array<int, 2> paperSize (unit: mm)
     * int outputWidth (unit: mm)
     * int compressionLevel
     */
    static
    std::expected<
        std::tuple<
            std::vector<std::filesystem::path>,
            std::filesystem::path,
            std::array<int, 2>,
            int,
            int,
            int,
            std::array<int, 4>,
            std::array<int, 2>
        >,
        std::string
    >
    getOptions(const int& argc, const std::vector<std::string>& argVector);

private:

    static std::vector<std::filesystem::path> getImagePaths(const std::string& str);
    static std::array<int, 4> getMargins(const std::string& str);
    static std::array<int, 2> getSpacings(const std::string& str);

    static std::expected<int, std::string> getDigitsFromString(const std::string& str);

};

#endif //LIBIMAGETOPDF_OPTIONS_H