#include "help.h"


void Help::showHelp(const std::string& option) {
    if (option == "-v" || option == "--help") {
        std::cout << "libImageToPDF\n\n"
                     "A library that converts images to a multi-page PDF document.\n\n";
        std::cout << "Version 1.0.0\n\n";
        std::cout << "The library is released under GNU Lesser General Public License version 3.0,\n"
                     "while the executable program is released under Apache License version 2.0.\n\n";

        std::cout << "The library dynamically uses libjpeg, libpng and zlib.\n";

#ifdef _WIN32
        std::cout << "libImageToPDF is distributed together with the libraries under different licenses.\n"
                     "Please read the licenses folder for knowing further information.\n\n";
#else
        std::cout << "Please install the packages of libturbojpeg and libpng if the system you are\n"
                     "using does not install them by default.\n\n";
#endif

    }

    if (option == "-h" || option == "--help") {
        std::cout << "How to Use the Executable Program\n\n"
                     "imageToPDF "
                     "-i image1.jpg image2.png image3.jpg image4.jpg image5.png "
                     "-o images.pdf "
                     "-p 210x297 -w 80 -q 90 -n 2 --set-margin 5 5 10 10 --set-spacing 2 4\n\n";
        std::cout << "If the path of a file contains a space,\n"
                     "the path should be enclosed in double quotation marks.\n\n";
        std::cout << "Options:\n\n";
        std::cout << "-i              Paths of images.\n"
                     "                JPEG and PNG images are supported.\n"
                     "                Image paths are separated by a space or a comma.\n"
                     "                Images appear in a PDF document with the same order.\n"
                     "For example:\n"
                     "-i image1.jpg image2.jpg image3.jpg\n"
                     "-i image1.jpg,image2.jpg,image3.jpg\n\n"
                     "-o              The output pdf path.\n"
                     "For example:\n"
                     "-o images.pdf\n"
                     "Note:\n"
                     "Without the option, a random name is given to the output file.\n\n"
                     "-p              The size of paper in millimeters.\n"
                     "For example:\n"
                     "-p 210x297\n"
                     "Note:\n"
                     "Without the option, the default size is an image's size.\n\n"
                     "-w              The output width of images in millimeters.\n"
                     "                The images will be resized based on the ratio of\n"
                     "                width and height.\n"
                     "For example:\n"
                     "-w 120\n"
                     "Note:\n"
                     "The option can effectively reduce the size of a PDF document.\n"
                     "Without the option, the original size of images is kept.\n\n"
                     "-q              The output quality of images.\n"
                     "                It's an integer between 1 and 100.\n"
                     "                100 is the best quality.\n"
                     "For example:\n"
                     "-q 90\n"
                     "Note:\n"
                     "Without the option, JPEG images keep their original quality,\n"
                     "while PNG images are compressed using JPEG format with the quality of 95.\n"
                     "When the value is set to 100, images are encoded with PNG format,\n"
                     "which may greatly increase the size of a PDF document.\n\n"
                     "-n              The number of images per page.\n"
                     "For example:\n"
                     "-n 2\n"
                     "Note:\n"
                     "Without the option, there is only one image per page.\n"
                     "If the number is over 1 but the -p option is not set, the size of paper\n"
                     "will be set to 210x297 by default.\n\n"
                     "--set-margin    Margins of paper in millimeters.\n"
                     "                The order of margins is top, bottom, left, right.\n"
                     "For example:\n"
                     "(1) Set all margins to the same: --set-margin 5\n"
                     "(2) Only set top and bottom margins: --set-margin 5 5\n"
                     "(3) Set all margins: --set-margin 5 5 10 10\n"
                     "Note:\n"
                     "Without the option, there is no margin on paper.\n\n"
                     "--set-spacing   Spacings of images in millimeters.\n"
                     "                The order of spacings is horizontal, vertical.\n"
                     "For example:\n"
                     "(1) Set all spacings to the same: --set-spacing 2\n"
                     "(2) Set all spacings: --set-spacing 2 4\n"
                     "Note:\n"
                     "Without the option, there is no spacing between images.\n\n";
    }
}
