#ifndef LIBIMAGETOPDF_CALCULATOR_H
#define LIBIMAGETOPDF_CALCULATOR_H

#include <array>
#include <vector>


class Calculator {

public:

    static int convertMMToPoints(const int& millimeters);
    static int convertMMToPixels(const int& millimeters, const int& dpi);
    static int convertPixelsToPoints(const int& pixels, const int& dpi);
    static int convertPointsToPixels(const int& points, const int& dpi);

    static std::vector<std::array<int, 4>> getObjectRectsInArea(
        const std::array<int, 2>& areaSize,
        const std::vector<std::array<int, 2>>& objectSizes,
        const std::array<int, 4>& margins,
        const std::array<int, 2>& spacings
    );

    static std::vector<std::array<int, 4>> getCenteredObjectRects(
        const std::vector<std::vector<std::array<int, 4>>>& layout
    );

private:


};

#endif //LIBIMAGETOPDF_CALCULATOR_H