#ifndef LIBAICONNECT_NET_H
#define LIBAICONNECT_NET_H

#include <expected>
#include <vector>
#include <iostream>

class Net {

public:

    static std::expected<std::string, std::string> aiDispatcher(
        const std::string& connectionProvider,
        const std::string& connectionKey,
        const std::string& connectionModel,
        std::string connectionRoleInstruction,
        std::string connectionDetailedInstructions,
        std::string connectionContent,
        const std::string& maxOutputTokens);

private:

    static std::tuple<std::string, std::vector<std::string>, std::string>
    prepareOpenAIParameters(
        const std::string& connectionKey,
        const std::string& connectionModel,
        const std::string& connectionRoleInstruction,
        const std::string& connectionDetailedInstructions,
        const std::string& connectionContent);

    static std::tuple<std::string, std::vector<std::string>, std::string>
    prepareClaudeParameters(
        const std::string& connectionKey,
        const std::string& connectionModel,
        const std::string& connectionRoleInstruction,
        const std::string& connectionDetailedInstructions,
        const std::string& connectionContent,
        const std::string& maxOutputTokens);

    static std::tuple<std::string, std::vector<std::string>, std::string>
    prepareGeminiParameters(
        const std::string& connectionKey,
        const std::string& connectionModel,
        const std::string& connectionRoleInstruction,
        const std::string& connectionDetailedInstructions,
        const std::string& connectionContent);

    static std::tuple<std::string, std::vector<std::string>, std::string>
    prepareMistralParameters(
        const std::string& connectionKey,
        const std::string& connectionModel,
        const std::string& connectionRoleInstruction,
        const std::string& connectionDetailedInstructions,
        const std::string& connectionContent);

    static std::expected<std::vector<uint8_t>, std::string> getReply(
        const std::tuple<std::string, std::vector<std::string>, std::string>& apiParameters);

    static size_t curlWriteCallback(char* data, size_t size, size_t nmemb, void* userdata);

};

#endif //LIBAICONNECT_NET_H