#include "help.h"

void Help::showHelp(std::string_view option) {
    if (option == "-v" || option == "--help") {
        std::cout << "libAIConnect\n\n"
                     "A library for utilizing the API of OpenAI, Claude AI, Google Gemini or Mistral AI.\n\n";
        std::cout << "Version 1.0.3\n\n";
        std::cout << "The library is released under GNU Lesser General Public License version 3.0,\n"
                     "while the executable program is released under Apache License version 2.0.\n\n";
        std::cout << "The program dynamically uses the library libcurl.\n"
                     "Please install the package libcurl before using libAIConnect.\n\n"
                     "The program also dynamically uses the library libJSONHandle,\n"
                     "which is distributed together.\n\n";
    }

    if (option == "-h" || option == "--help") {
        std::cout << "How to Use the Executable Program\n\n";
        std::cout << "aiConnect [options]\n\n";
        std::cout << "The config file of the program is saved in ~/.config/aiConnect/aiConnect.conf\n\n";
        std::cout << "Options:\n\n";
        std::cout <<
            "Part I: Add/Update Keys, Models or Roles\n\n"
            "--add-key        Add or update an API key.\n"
            "                 The AI provider's name and the API key are required, which are separated \n"
            "                 by a colon.\n"
            "                 Different provider names with keys are separated by a comma.\n"
            "                 Supported AI provider names: OpenAI, Gemini, Claude, Mistral.\n"
            "For example:\n"
            "--add-key OpenAI:key1, Gemini:key2\n"
            "Note:\n"
            "If you just simply input --add-key without giving any information,\n"
            "the program will ask about the information step by step.\n"
            "If the AI provider's API key has been saved before, the command will update it.\n\n"
            "--add-model      Add or update an AI model.\n"
            "                 The AI provider's name, the custom name of the model, and the\n"
            "                 identifier name of the model are required, which are separated \n"
            "                 by a colon.\n"
            "                 Different models are separated by a comma.\n"
            "                 The identifier name of a model is used for API connections, but\n"
            "                 the custom name of the model can be set by yourself.\n"
            "                 When inputting a custom name with a space, please enclose the name\n"
            "                 in double quotation marks.\n"
            "For example:\n"
            "--add-model Claude:\"Claude Sonnet 4\":claude-sonnet-4-20250514, "
            "Mistral:\"Codestral 2508\":codestral-2508\n"
            "Note:\n"
            "If you just simply input --add-model without giving any information,\n"
            "the program will ask about the information step by step.\n"
            "If the custom name with the AI provider has been saved before, the command will update\n"
            "the identifier name.\n\n"
            "--add-role       Add or update a preset role with instructions.\n"
            "                 The role's name, the role instruction, and detailed instructions are\n"
            "                 required, which are separated by a colon.\n"
            "                 If the role's name, the role instruction or detailed instructions\n"
            "                 contains a space, it should be enclosed in double quotation marks,\n"
            "                 or you may enclose the entire string for a preset role in double\n"
            "                 quotation marks.\n"
            "                 During an API connection, role instruction is generally combined with\n"
            "                 detailed instructions as a part of the value of content. Buf if an API\n"
            "                 supports a separate definition for a role, the role instruction may be\n"
            "                 sent separately.\n"
            "For example:\n"
            "--add-role translator:\"You are a translator.\":\"Requirements: 1. Please give the entire "
            "text of your translation firstly, which is enclosed in <translation></translation>, and "
            "then give your comment, which is enclosed in <comment></comment>; 2. The translation "
            "follows native expressions of the target language; 3. For confusing meanings, please "
            "provide detailed explanation in your comment.\"\n"
            "--add-role \"translator:You are a translator.:Requirements: 1. Please give the entire "
            "text of your translation firstly, which is enclosed in <translation></translation>, and "
            "then give your comment, which is enclosed in <comment></comment>; 2. The translation "
            "follows native expressions of the target language; 3. For confusing meanings, please "
            "provide detailed explanation in your comment.\"\n"
            "Note:\n"
            "If you just simply input --add-role without giving any information,\n"
            "the program will ask about the information step by step.\n"
            "If the role name has been saved before, the command will update the role instruction and\n"
            "detailed instructions.\n\n"
            "Part II: Show Keys, Models or Roles\n\n"
            "--show-keys      Show all saved API keys.\n\n"
            "--show-models    Show all saved AI models.\n\n"
            "--show-roles     Show the names of all preset roles.\n\n"
            "--show-role      Show the details of a preset role.\n"
            "                 Please give the role's name.\n"
            "                 For showing the details of multiple roles, please separate their names\n"
            "                 by a comma.\n"
            "For example:\n"
            "--show-role translator, teacher\n"
            "Note:\n"
            "If you just simply input --show-role without giving any information,\n"
            "the program will ask about the information step by step.\n\n"
            "Part III: Remove Keys, Models or Roles\n\n"
            "--remove-key     Remove an API key.\n"
            "                 Please give the AI provider's name that you inputted for adding the key.\n"
            "                 Supported AI provider names: OpenAI, Gemini, Claude, Mistral.\n"
            "                 For removing multiple keys, please separate the names of AI providers\n"
            "                 by a comma.\n"
            "For example:\n"
            "--remove-key OpenAI, Gemini\n"
            "Note:\n"
            "If you just simply input --remove-key without giving any information,\n"
            "the program will ask about the information step by step.\n\n"
            "--remove-model   Remove an AI model.\n"
            "                 Please give the AI provider's name and the custom name of the model, which\n"
            "                 are separated by a colon.\n"
            "                 If the custom name of a model contains a space, please enclose the name in\n"
            "                 double quotation marks.\n"
            "                 For removing multiple models, please separate different models by a comma.\n"
            "For example:\n"
            "--remove-model Claude:\"Claude Sonnet 4\", Mistral:\"Codestral 2508\"\n"
            "Note:\n"
            "If you just simply input --remove-model without giving any information,\n"
            "the program will ask about the information step by step.\n\n"
            "--remove-role    Remove a preset role.\n"
            "                 Please give the role's name.\n"
            "                 For removing multiple roles, please separate their names by a comma.\n"
            "For example:\n"
            "--remove-role translator, teacher\n"
            "Note:\n"
            "If you just simply input --remove-role without giving any information,\n"
            "the program will ask about the information step by step.\n\n"
            "Part IV: Use AI\n\n"
            "-model           Specify an AI model.\n"
            "                 Please input the custom name of the model.\n"
            "                 If the name includes a space, it should be enclosed in double quotation marks.\n"
            "For example:\n"
            "-model \"Claude Sonnet 4\"\n"
            "Note:\n"
            "If you just simply input -model without giving any information,\n"
            "the program will ask about the information step by step.\n"
            "If models from different providers have the same custom name,\n"
            "one of the models will be randomly used.\n\n"
            "-role            Specify a preset role for AI, or give a role instruction to AI.\n"
            "                 For choosing a role that is created by the --add-role option,\n"
            "                 please input the role's name.\n"
            "                 A role instruction to AI should be enclosed in double quotation marks.\n"
            "For example:\n"
            "-role translator\n"
            "-role \"You are a translator.\"\n"
            "Note:\n"
            "If you just simply input -role without giving any information,\n"
            "the program will ask about the information step by step.\n\n"
            "-content         Give specific instructions to AI.\n"
            "                 If you have set a preset role, please do not repeat the detailed\n"
            "                 instructions for the role, because the detailed instructions for the\n"
            "                 preset role will be sent together with the specific instructions as\n"
            "                 the value of content during an API connection.\n"
            "                 Please enclose the instructions in double quotation marks.\n"
            "                 "
            "For example:\n"
            "-content \"Please translate the contents enclosed in <text></text> into Chinese: "
            "<text>Do not treat others the way you do not want to be treated.</text>\"\n"
            "Note:\n"
            "If you just simply input -content without giving any information,\n"
            "the program will ask about the information step by step.\n"
            "If no information is given, the program will not perform an API connection.\n\n";
    }
}
