#include <iostream>
#include <ranges>
#include <filesystem>

#include "options.h"
#include "help.h"
#include "net.h"


int main(int argc, char *argv[])
{
    if (argc == 1) {
        Help::showHelp("--help");
        return 0;
    }

    for (int i = 1; i < argc; ++i) {
        std::string arg = argv[i];
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            Help::showHelp(argv[i]);
            return 0;
        }
    }

    auto optionsResult = Options::getOptions(argc, argv);

    if (!optionsResult.has_value()) {
        std::cout << optionsResult.error() << std::endl;
        return 1;
    }

    auto [
        connectionProvider,
        connectionKey,
        connectionModel,
        connectionRoleInstruction,
        connectionDetailedInstructions,
        connectionContent
        ] = optionsResult.value();

    auto reply = Net::aiDispatcher(
        connectionProvider,
        connectionKey,
        connectionModel,
        connectionRoleInstruction,
        connectionDetailedInstructions,
        connectionContent);

    if (reply.has_value()) {
        std::cout << reply.value() << std::endl;
    } else {
        std::cout << reply.error() << std::endl;
    }

    return 0;
}
